---
title: Update billing information · Cloudflare Billing docs
description: To avoid potential disruptions in your Cloudflare services, make
  sure your billing information is current and accurate.
lastUpdated: 2025-09-03T18:47:47.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/billing/update-billing-info/
  md: https://developers.cloudflare.com/billing/update-billing-info/index.md
---

To avoid potential disruptions in your Cloudflare services, make sure your billing information is current and accurate.

If Cloudflare is unable to process your payment, review [Troubleshooting failed payments](https://developers.cloudflare.com/billing/troubleshoot-failed-payments/).

## Update payment methods

Note

You may receive the error message "Cannot add more than two payment methods." when trying to add additional methods.

If you are unable to add or edit a payment method, [delete a payment method](https://developers.cloudflare.com/billing/update-billing-info/#delete-a-payment-method) and try again.

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Select **Payment**.

3. Select **Manage** next to your current payment method. The **Manage payment methods** dialog opens.

4. Select **Edit** next to the payment method you would like to edit.

5. Enter the required information and select **Save Payment Information**.

## Delete a payment method

Before removing your payment method from file, you must cancel all Cloudflare paid services.

Warning

If you currently subscribe to any [add-on services](https://developers.cloudflare.com/billing/usage-based-billing/), Cloudflare must always have a payment method on file. If you need to remove a payment method, you must enter a new one to replace it.

You cannot delete a payment method if a payment fails or if there is an outstanding balance. Until Cloudflare processes payment, you can only add or edit your payment method.

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Select **Payment**.

3. From **Payment methods**, select **Manage**.

4. Next to your current payment method, select **Delete**.

5. Select **Confirm** to finish.

## Update your billing address

The billing address is associated with your payment method and is used to calculate your sales tax. If you need to update your billing address, you must also enter your payment method. The process for updating your billing address depends on the payment method.

If paying by credit card:

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. From **Billing Address**, select **Edit** and enter your information.

3. Review the suggested address in the pop-up window. If the information is correct, select **Confirm**.

If paying by PayPal, refer to PayPal's [billing address documentation](https://www.paypal.com/ai/smarthelp/article/how-do-i-edit-the-billing-address-linked-to-my-credit-card-faq680).

## Update billing email address

Your billing email address is particularly important if you have [opted into email invoices](https://developers.cloudflare.com/billing/invoices/#enable-email-invoices-from-cloudflare).

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Go to **Invoices and documents**.

3. From **Billing email preference**, select **Change email address**.

4. Enter and confirm your new email address, then select **Save**.

## Add or change a Tax ID, VAT, or GST number

If you added a payment method but did not include a Tax ID, VAT or GST number, you can add or change the Tax ID, VAT or GST number associated with the payment method afterwards.

Note

You cannot apply a VAT or GST number to past invoices. Adding a VAT or GST number will only apply to future invoices issued in the account.

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Go to **Payment**.

3. From **Billing Address**, select **Edit**.

4. In the **VAT/GST** field, enter your VAT or GST number.

5. Select **Confirm**.

## Remove a Tax ID, VAT, or GST number

Note

You cannot remove a VAT or GST number from past invoices. Removing a VAT or GST number will only apply to future invoices issued in the account.

1. In the Cloudflare dashboard, go to the **Billing** page.

   [Go to **Billing**](https://dash.cloudflare.com/?to=/:account/billing)

2. Go to **Payment**.

3. From **Billing Address**, select **Edit**.

4. In the **VAT/GST** field, delete the VAT or GST number.

5. Select **Confirm**.
