---
title: Set retention polices for your R2 bucket with bucket locks · Changelog
description: Set retention polices for your R2 bucket with bucket locks
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-03-06-r2-bucket-locks/
  md: https://developers.cloudflare.com/changelog/2025-03-06-r2-bucket-locks/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Set retention polices for your R2 bucket with bucket locks

Mar 06, 2025

[R2](https://developers.cloudflare.com/r2/)

You can now use [bucket locks](https://developers.cloudflare.com/r2/buckets/bucket-locks/) to set retention policies on your [R2 buckets](https://developers.cloudflare.com/r2/buckets/) (or specific prefixes within your buckets) for a specified period — or indefinitely. This can help ensure compliance by protecting important data from accidental or malicious deletion.

Locks give you a few ways to ensure your objects are retained (not deleted or overwritten). You can:

* Lock objects for a specific duration, for example 90 days.
* Lock objects until a certain date, for example January 1, 2030.
* Lock objects indefinitely, until the lock is explicitly removed.

Buckets can have up to 1,000 [bucket lock rules](https://developers.cloudflare.com/r2/buckets/). Each rule specifies which objects it covers (via prefix) and how long those objects must remain retained.

Here are a couple of examples showing how you can configure bucket lock rules using [Wrangler](https://developers.cloudflare.com/workers/wrangler/):

#### Ensure all objects in a bucket are retained for at least 180 days

```sh
npx wrangler r2 bucket lock add <bucket> --name 180-days-all --retention-days 180
```

#### Prevent deletion or overwriting of all logs indefinitely (via prefix)

```sh
npx wrangler r2 bucket lock add <bucket> --name indefinite-logs --prefix logs/ --retention-indefinite
```

For more information on bucket locks and how to set retention policies for objects in your R2 buckets, refer to our [documentation](https://developers.cloudflare.com/r2/buckets/bucket-locks/).
