---
title: Proxy · Cloudflare One docs
description: You can forward HTTP and network traffic to Gateway for logging and
  filtering. Gateway can proxy both outbound traffic and traffic directed to
  resources connected via a Cloudflare Tunnel, GRE tunnel, or IPsec tunnel. When
  a user connects to the Gateway proxy, Gateway will accept the connection and
  establish a new, separate connection to the origin server.
lastUpdated: 2025-11-21T16:14:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/proxy/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/proxy/index.md
---

You can forward [HTTP](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/http/) and [network](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/network/) traffic to Gateway for logging and filtering. Gateway can proxy both outbound traffic and traffic directed to resources connected via a Cloudflare Tunnel, GRE tunnel, or IPsec tunnel. When a user connects to the Gateway proxy, Gateway will accept the connection and establish a new, separate connection to the origin server.

The Gateway proxy is required for filtering HTTP and network traffic via the WARP client in Gateway with WARP mode. To proxy HTTP traffic without deploying the WARP client, you can configure [PAC files](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/pac-files/) on your devices.

## Proxy algorithm

Gateway uses the [Happy Eyeballs algorithm](https://datatracker.ietf.org/doc/html/rfc6555) to proxy traffic in the following order:

1. The user's browser initiates the TCP handshake by sending Gateway a TCP SYN segment.
2. Gateway sends a SYN segment to the origin server.
3. If the origin server sends a SYN-ACK segment back, Gateway establishes separate TCP connections between the user and Gateway and between Gateway and the origin server.
4. Gateway inspects and filters traffic received from the user.
5. If the traffic passes inspection, Gateway proxies traffic bidirectionally between the user and the origin server.

```mermaid
flowchart TD
    %% Accessibility
    accTitle: How Gateway proxy works
    accDescr: Flowchart describing how the Gateway proxy uses the Happy Eyeballs algorithm to establish TCP connections and proxy user traffic.

    %% Flowchart
    A[User's device sends TCP SYN to Gateway] --> B[Gateway sends TCP SYN to origin server]
    B --> C{{Origin server responds with TCP SYN-ACK?}}
    C -->|Yes| E[TCP handshakes completed]
    C -->|No| D[Connection fails]
    E --> F{{Connection allowed?}}
    F -->|Allow policy| G[Gateway proxies traffic bidirectionally]
    F -->|Block policy| H[Connection blocked by firewall policies]

    %% Styling
    style D stroke:#D50000
    style G stroke:#00C853
    style H stroke:#D50000
```

## Supported protocols

Gateway supports proxying TCP, UDP, and ICMP traffic.

### TCP

When the proxy is enabled, Gateway will always forward TCP traffic.

By default, TCP connection attempts will timeout after 30 seconds and idle connections will disconnect after 8 hours.

### UDP

The UDP proxy forwards UDP traffic such as VoIP, [internal DNS requests](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/private-dns/), and thick client applications.

For HTTP/3 traffic to be logged and filtered, you need to turn on both TLS decryption and the Gateway proxy for UDP so that Gateway will force all HTTP/3 traffic to HTTP/2 to allow inspection. Otherwise, HTTP/3 traffic will bypass inspection. For more information, refer to [HTTP/3 inspection](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/http3/).

### ICMP Beta

The ICMP proxy forwards traffic for diagnostic tools such as `ping` and `traceroute`.

Limitation

Gateway cannot log or filter ICMP traffic.

#### Allow ICMP traffic through `cloudflared`

To use the ICMP proxy with Cloudflare Tunnel, you may need to configure the `cloudflared` host to allow ICMP traffic through `cloudflared`.

* Linux

  1. Ensure that `ping_group_range` includes the Group ID (GID) of the user running `cloudflared`:

     a. Find the user that owns the `cloudflared` process:

     ```sh
     ps -aux | grep cloudflared
     ```

     ```sh
     johndoe         407  0.8  1.7 1259904 35296 ?       Ssl  21:02   0:00 /usr/bin/cloudflared --no-autoupdate tunnel run --token eyJhI...
     ```

     b. Get the Group ID of the `cloudflared` user:

     ```sh
     id -g johndoe
     ```

     ```sh
     10001
     ```

     c. Determine the Group IDs that are allowed to use ICMP:

     ```sh
     sudo sysctl net.ipv4.ping_group_range
     ```

     ```sh
     net.ipv4.ping_group_range= 0 10000
     ```

     d. Either add the user to a group within that range, or update the range to encompass a group the user is already in. To update `ping_group_range`:

     ```sh
     echo 0 10001 | sudo tee /proc/sys/net/ipv4/ping_group_range
     ```

     e. If you need to make the change apply to an already running process, you need to restart `cloudflared`. To make the change persist on reboot, update your `systcl` parameters:

     ```sh
     echo "net.ipv4.ping_group_range = 0 10001" | sudo tee -a /etc/sysctl.d/99-cloudflared.conf
     ```

  2. If you are running multiple network interfaces (for example, `eth0` and `eth1`), configure `cloudflared` to use the external Internet-facing interface:

     ```sh
     cloudflared tunnel run --icmpv4-src <IP of primary interface>
     ```

* Docker

  In your environment, modify the `ping_group_range` parameter to include the Group ID (GID) of the user running `cloudflared`.

  By default the [`cloudflared` Docker container](https://github.com/cloudflare/cloudflared/blob/master/Dockerfile#L29C6-L29C13) executes as a user called `nonroot` inside of the container. `nonroot` is a specific user that exists in the [base image](https://github.com/GoogleContainerTools/distroless/blob/859eeea1f9b3b7d59bdcd7e24a977f721e4a406c/base/base.bzl#L8) we use, and its Group ID is hardcoded to 65532.

## Turn on the Gateway proxy

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Traffic policies** > **Traffic settings**.
2. In **Proxy and inspection settings**, turn on **Allow Secure Web Gateway to proxy traffic**.
3. Select **TCP**.
4. (Optional) Depending on your use case, you can select **UDP** and/or **ICMP**.
