---
title: Protect against random prefix attacks · Cloudflare DNS docs
description: "In order to enable automatic mitigation of random prefix attacks:"
lastUpdated: 2025-05-12T14:31:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/dns-firewall/random-prefix-attacks/setup/
  md: https://developers.cloudflare.com/dns/dns-firewall/random-prefix-attacks/setup/index.md
---

In order to enable automatic mitigation of [random prefix attacks](https://developers.cloudflare.com/dns/dns-firewall/random-prefix-attacks/about/):

1. Set up [DNS Firewall](https://developers.cloudflare.com/dns/dns-firewall/setup/).

2. Send a [`PATCH` request](https://developers.cloudflare.com/api/resources/dns_firewall/methods/edit/) to update your DNS Firewall cluster.

   Required API token permissions

   At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

   * `DNS Firewall Write`

   ```bash
   curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/dns_firewall/$DNS_FIREWALL_ID" \
     --request PATCH \
     --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
     --json '{
       "attack_mitigation": {
           "enabled": true,
           "only_when_upstream_unhealthy": true
       }
     }'
   ```

Once you receive a `200` success response from the API, queries identified as being part of a random prefix attack will receive a `REFUSED` response.

Note

If you do not specify otherwise in your API call, Cloudflare automatically sets the `"only_when_upstream_unhealthy"` parameter to true, which means that Cloudflare will only mitigate attacks when we detect that the upstream is unresponsive (possibly as a result of an attack). This setting can also be changed via the API, using a request similar to the ones shown above.
