---
title: Set up multi-signer DNSSEC with outgoing zone transfers · Cloudflare DNS docs
description: With outgoing zone transfers, you keep Cloudflare as your primary
  DNS provider and use one or more secondary providers for increased
  availability and fault tolerance.
lastUpdated: 2025-10-23T07:57:47.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-primary/dnssec-for-primary/
  md: https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-primary/dnssec-for-primary/index.md
---

With [outgoing zone transfers](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-primary/), you keep Cloudflare as your primary DNS provider and use one or more secondary providers for increased availability and fault tolerance.

If you want to use DNSSEC with outgoing zone transfers, you should configure [multi-signer DNSSEC](https://developers.cloudflare.com/dns/dnssec/multi-signer-dnssec/). After setting up [Cloudflare as primary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-primary/setup/), follow the steps below to enable DNSSEC.

## Before you begin

Note that:

* This process requires that your other DNS provider(s) also support multi-signer DNSSEC.
* Although you can complete a few steps via the dashboard, currently the whole process can only be completed using the API.
* Enabling **DNSSEC** and **Multi-signer DNSSEC** in [**DNS Settings**](https://dash.cloudflare.com/?to=/:account/:zone/dns/settings) only replaces the first step below. You still have to follow the rest of this tutorial to complete the setup.

## Steps

1. Use the [Edit DNSSEC Status endpoint](https://developers.cloudflare.com/api/resources/dns/subresources/dnssec/methods/edit/) to enable DNSSEC and activate multi-signer DNSSEC for your zone. This is done by setting `status` to `active` and `dnssec_multi_signer` to `true`, as in the following example.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `DNS Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/dnssec" \
  --request PATCH \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "status": "active",
    "dnssec_multi_signer": true
  }'
```

1. Add the ZSK(s) of your external provider(s) to Cloudflare by creating a DNSKEY record on your zone.

```bash
curl 'https://api.cloudflare.com/client/v4/zones/{zone_id}/dns_records' \
--header "X-Auth-Email: <EMAIL>" \
--header "X-Auth-Key: <API_KEY>" \
--header "Content-Type: application/json" \
--data '{
  "type": "DNSKEY",
  "name": "<ZONE_NAME>",
  "data": {
    "flags": 256,
    "protocol": 3,
    "algorithm": 13,
    "public_key": "<PUBLIC_KEY>"
  },
  "ttl": 3600
}'
```

1. Once the DNSKEY record is transferred out from Cloudflare to your secondary provider, get Cloudflare's ZSK and manually add it to the DNSKEY record.

   Currently, the ZSK is not automatically transferred out. You can use either the API or a query from one of the assigned Cloudflare nameservers to obtain it.

API example:

```bash
curl 'https://api.cloudflare.com/client/v4/zones/{zone_id}/dnssec/zsk' \
--header "X-Auth-Email: <EMAIL>" \
--header "X-Auth-Key: <API_KEY>"
```

Command line query example:

```sh
$ dig <ZONE_NAME> dnskey @<CLOUDFLARE_NAMESERVER> +noall +answer | grep 256
```

1. Add DS records to your registrar, one for each provider. You can see your Cloudflare DS record on the [**DNS Settings**](https://dash.cloudflare.com/?to=/:account/:zone/dns/settings) page, under **DS Record**.

The nameserver settings at your registrar should include the nameservers of all providers you will be using for your multi-signer DNSSEC setup.
