---
title: Move a domain between Cloudflare accounts · Cloudflare Fundamentals docs
description: Learn how to transfer a domain between Cloudflare accounts,
  including requirements, DNS settings, and SSL/TLS certificate management for
  seamless migration.
lastUpdated: 2025-06-30T19:06:55.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/manage-domains/move-domain/
  md: https://developers.cloudflare.com/fundamentals/manage-domains/move-domain/index.md
---

You will have to move or transfer domains from one Cloudflare account to another if you:

* Manage a multi-user organization and need to segment domain access by user.
* Receive a `Cloudflare is already hosting under a different account` error.
* Lose access to your email address or Cloudflare account (though you can also use the [backup codes](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/#use-a-backup-code) if you have two-factor authentication enabled).
* Registered a Cloudflare account with a typo in your email.

Warning

If your domain is registered with Cloudflare Registrar, you need to submit a manual request to transfer the domain and its registration to a new account.

Refer to [Transfer a Cloudflare Registrar domain registration between accounts](https://developers.cloudflare.com/registrar/account-options/inter-account-transfer/) to complete this process.

## Requirements

To transfer a domain from one Cloudflare account to another, you will need:

* Access to your domain registrar. If your domain is using Cloudflare Registrar, refer to [Transfer a Cloudflare Registrar domain registration between accounts](https://developers.cloudflare.com/registrar/account-options/inter-account-transfer/).
* At least one Cloudflare account associated with the domain.

## Transfer your domain

Warning

Before transferring an active Cloudflare domain to another Cloudflare account, you must remove any [DNSSEC configurations](https://developers.cloudflare.com/dns/dnssec/) and [add-ons or subscriptions](https://developers.cloudflare.com/billing/cancel-subscription/).

We also recommend [exporting](https://developers.cloudflare.com/dns/manage-dns-records/how-to/import-and-export/#export-records) the DNS records of your zone while it is in the previous account. Then, you can [import](https://developers.cloudflare.com/dns/manage-dns-records/how-to/import-and-export/#import-records) the correct DNS records into the new account. If you miss this step, Cloudflare will import your proxied DNS records, which might cause your domain to experience a [1000 error](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-1xxx-errors/).

If you still have access to your previous Cloudflare account, you can copy over the Cloudflare account settings manually. You must reissue [SSL/TLS certificates](#issue-new-certificates) and [recreate and validate DNS records](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/) when transferring domains between Cloudflare accounts.

If you lose access to the email address associated with your Cloudflare account and do not have backup codes, you will need to manually transfer your domain to a new Cloudflare account associated with a different email address.

The domain transfer process depends on your DNS settings. If Cloudflare is your authoritative DNS provider (that is, your domain nameservers point to Cloudflare), you must:

1. [Create a new Cloudflare account](https://developers.cloudflare.com/fundamentals/account/create-account/) or log in to an existing Cloudflare account.
2. [Add the domain](https://developers.cloudflare.com/fundamentals/manage-domains/add-site/) to the account (as if you were adding it for the first time).
3. Log in to your domain registrar account and [update the nameservers](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/) to the provided Cloudflare nameservers.
4. Finalize the nameserver update by selecting your domain in the dashboard > **Overview** > **Re-check now**.

Once the Cloudflare network recognizes the nameserver change, the domain in the new account will be marked as **Active**. While the domain in the new account is **Pending**, it cannot proxy traffic through Cloudflare and the origin IP addresses will be returned until the domain is marked as **Active**.

In the old account, the domain will be marked as **Moved Away**. After seven days in **Moved Away** status, the domain will be marked as **Deleted**. After seven days in the **Deleted** status, the domain will be permanently removed.

For more information, refer to [Zone status](https://developers.cloudflare.com/dns/zone-setups/reference/domain-status/).

## Issue new certificates

SSL/TLS certificates associated with your previous Cloudflare account will not be transferred to your new account. If your site requires an SSL/TLS certificate prior to domain transfer, refer to [Minimize downtime](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/enable-universal-ssl/#minimize-downtime).

If you were using [custom certificates](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/), you will need to delete them from the previous zone and upload them to the new zone. You can upload the certificates while the new zone is in **Pending** status - if you do so, once you upload the certificates, they will have a [**Holding Deployment**](https://developers.cloudflare.com/ssl/reference/certificate-statuses/#custom-certificates) status and will become active once the zone is active.

You can order an [advanced certificate](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) prior to transferring your domain. ACM certificates will automatically deploy to active domains.
