---
title: Get started · Cloudflare Network Interconnect docs
description: "Eligibility for CNI and port availability is determined in
  coordination with your Cloudflare account team. Notably:"
lastUpdated: 2025-11-05T16:47:18.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/network-interconnect/get-started/
  md: https://developers.cloudflare.com/network-interconnect/get-started/index.md
---

## Prerequisites

### CNI port availability

Eligibility for CNI and port availability is determined in coordination with your Cloudflare account team. Notably:

* CNI ports are currently offered at no charge to Enterprise customers.
  * Non-Enterprise customers (and any third party) may peer with Cloudflare via Internet Exchange according to our [open peering policy](https://www.cloudflare.com/peering-policy/).

* CNI is available at select Cloudflare data centers:

  * The type of dataplane offered in that location will determine specifications of the supported connection, such as the MTU.
  * The diversity offered in the location will vary.

* Customers must have a BGP session established for CNI v1 to be operational.

### Product use cases

CNI provides a private point-to-point IP connection with Cloudflare. There are two dataplanes that come with different technical specifications.

| | Dataplane v1 | Dataplane v2 (beta) |
| - | - | - |
| **Magic Transit Direct Server Return (DSR)** DDoS protection for all ingress traffic from the Internet to your public network. Send egress traffic via your ISP. | Supported with or without a GRE tunnel established over the interconnect circuit. | Supported. |
| **Magic Transit with Egress** DDoS protection for all ingress traffic from the Internet to your public network. Send egress traffic via Cloudflare. | Supported with or without a GRE tunnel established over the interconnect circuit. | Supported. |
| **Magic WAN and Zero Trust** Build a secure, private network backbone connecting your Zero Trust users and applications with all your sites, data centers, and clouds. | Supported with or without a GRE tunnel established over the interconnect circuit. | Supported. |
| **Peering** Exchange public routes with a single Cloudflare PoP (Point of Presence). | Supported. All customers connecting with the edge data center will exchange public routes at that PoP with AS13335. Connectivity is established at each individual PoP. Routes for other edge locations in Cloudflare's network may not be available. Routes for customer-advertised prefixes will be available only in the connected PoP. | Not supported. |
| **Application Security and Performance** Improve the performance and security of your web applications | **Supported via peering**: Customers can use Argo Smart Routing to direct origin traffic via the edge peering connection when it is determined to be the lowest latency option. Customers must maintain a direct Internet connection which will always be used for a portion of traffic and during failure scenarios. **Supported Via Magic Transit**: Customers may configure any product with an origin server IP address that is protected by Magic Transit. Magic Transit will direct this traffic via the overlay and customer can control interconnect next-hops using the Magic networking routing table. | When the origin IPs are behind Magic Transit over a CNI v2, all Cloudflare services that work with public origins (like Load Balancer, WAF, Cache) will run over the CNI. |

For more details refer to the [prerequisites section](https://developers.cloudflare.com/network-interconnect/get-started/#prerequisites).

### Technical specifications

* **Supported port types (Direct CNI)**:

  * **Dataplane v1**: 10GBASE-LR (single-mode fiber) and 100GBASE-LR (single-mode fiber).
  * **Dataplane v2 (beta)**: 10GBASE-LR (single-mode fiber) and 100GBASE-LR4 (single-mode fiber) optics are supported.

* **Distance limitations:** Cloudflare does not support optical links longer than 10 km. For longer distances, you must use intermediate hardware or a third-party provider to extend the connection.

* **IP addressing:** All Direct and Partner CNI connections use a `/31` subnet for point-to-point IP connectivity between your router and Cloudflare.

* **VLAN support:**

  * **Dataplane v1**: CNI ports may be assigned a single 802.1Q VLAN tag.
  * **Dataplane v2 (beta)**: VLAN tagging (802.1Q) and QinQ are not yet supported.

* **MTU considerations:**

  * **Dataplane v1**: Supports a native 1,500-byte MTU for traffic from Cloudflare to you (ingress), but still requires a 1,476-byte MTU for traffic from you to Cloudflare (egress).
  * **Dataplane v2 (beta)**: Supports a maximum MTU of 1,500 bytes bidirectionally with no GRE requirement.

* **Bidirectional Forwarding Detection (BFD):**

  * **Dataplane v1**: BFD provides fast failure detection for BGP sessions and is supported on direct connections. To enable BFD, contact your account team. Note that BFD on a CNI does not impact the failover time for Magic Transit / WAN tunnels, which rely on separate health checks.
  * **Dataplane v2 (beta)**: Not yet supported.

* **Link Aggregation Control Protocol (LACP)**:

  * **Dataplane v1**: To increase bandwidth and provide link resiliency, Cloudflare supports combining multiple physical CNI ports into a single logical channel using Link Aggregation Control Protocol (LACP). You can bundle multiple connections to increase total throughput and add redundancy to your private connection with Cloudflare.
  * **Dataplane v2 (beta)**: Not yet supported. Use ECMP instead.

### Performance characteristics

The following are the maximum throughput rates supported by the CNI connection. Actual performance will depend on your specific use case and configuration.

| Direction (use case) | 10G Circuit | 100G Circuit |
| - | - | - |
| From Cloudflare to Customer (all use cases) | Up to 10 Gbps | Up to 100 Gbps |
| From Customer to Cloudflare (peering use case) | Up to 10 Gbps | Up to 100 Gbps |
| From Customer to Cloudflare (Magic Transit/WAN) | • **v1**: Up to 1 Gbps per GRE tunnel over the CNI • **v2 (beta)**: Up to 1 Gbps per CNI connection | • **v1**: Up to 1 Gbps per GRE tunnel over the CNI • **v2 (beta)**: Up to 1 Gbps per CNI connection |

### Service expectations

Consider the following service levels when planning your deployment:

* **No Formal SLA**:

  * CNI is currently offered at no charge and without a formal [Service Level Agreement (SLA)](https://www.cloudflare.com/service-specific-terms-network-services/#cf-network-interconnect-terms).
  * Cloudflare will work to restore CNI service in the event of a Cloudflare issue. In some Cloudflare data centers the recovery time could be several days. Therefore we always recommend backup connectivity to a different device or via an Internet tunnel.

* **Observability**: There is no visibility of the interconnect config/status within the Cloudflare dashboard.

* **Availability**: While network-resilient locations are designed to maintain connectivity during maintenance, single-homed locations can experience full service disruption.

* **Backup Connectivity**: You are required to maintain alternative Internet connectivity as a backup for all CNI implementations.

## Location alignment

### Available locations

Direct connections are available at any Cloudflare data center where you are also located. Make sure to check whether the location of interest has the right dataplane version and diversity requirements for your use case. Refer to [available locations](https://developers.cloudflare.com/network-interconnect/static/cni-locations-30-10-2025.pdf) (PDF) for details.

### Connectivity partners

Cloudflare partners with leading global providers, including: Console Connect, CoreSite, Digital Realty, Equinix Fabric, Megaport, PacketFabric, and Zayo.

## End-to-end implementation workflow

The process of provisioning a CNI typically takes two to four weeks, depending on the complexity of implementation and third-party provider timelines. The most common delays occur during the physical connection phase, which is outside of Cloudflare's direct control.

1. **Submit request**: Work with your account team to create a CNI request ticket, providing your desired CNI type, location, use case, and technical details. An Implementation Manager will be assigned to guide the process.

2. **Review configuration**: For the v1 dataplane, The Implementation Manager will provide a detailed configuration document covering IP addressing, VLANs, and other technical specifications. You must review and approve this document. For the v2 dataplane, this step is not necessary.

3. **Order connection**:

   * For a **Direct Interconnect**, you will receive a Letter of Authorization (LOA) from Cloudflare to order the physical cross-connect from the data center facility operator.
   * For a **Partner Interconnect**, you will use the provided details to order a virtual circuit from the partner's portal.

4. **Configure network**: Both Cloudflare and your network team will configure the respective network devices according to the approved document.

5. **Test and verify**: Once the connection is physically established, teams will perform basic connectivity tests (for example, ping) and, if applicable, verify that the BGP session can be established.

6. Enable tunnel health checks for [Magic Transit](https://developers.cloudflare.com/magic-transit/how-to/configure-tunnel-endpoints/#add-tunnels) and / or [Magic WAN](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/#add-tunnels).

7. **Activate services**: Configure your Cloudflare products (for example, Magic Transit) to route traffic over the new CNI. The Implementation Manager will verify end-to-end traffic flow before marking the deployment as complete.

8. [Add maintenance notifications](https://developers.cloudflare.com/network-interconnect/monitoring-and-alerts/#enable-cloudflare-status-maintenance-notification).

## How-to guides

### How-to: Provision a Direct Interconnect

1. **Project Kickoff**: In an initial kickoff call, you will confirm the scope and timeline with Cloudflare. Be prepared to provide the following information:

   * desired colocation facility
   * required port speeds (10G or 100G)
   * BGP ASN for Peering/Magic Transit
   * BGP password (optional)

2. **Order Cross-Connect**: Cloudflare will issue a Letter of Authorization (LOA). This document grants you permission to order a physical cross-connect between your equipment and a specific port on Cloudflare's hardware within the data center. The end-to-end process for ordering a cross-connect can take one to two weeks or more, depending on the facility provider. Cloudflare's demarcation is the port that is specified in the LOA: you are responsible for the deployment, provisioning and ongoing support and operation of this connection, and the commercial relationships with the facility provider and any third-party connectivity providers.

### How-to: Provision a Partner Interconnect

Cloudflare partners with leading connectivity providers globally. To provision a Partner Interconnect, you will initiate a connection request from your chosen provider's administrative portal. Cloudflare will then review and accept the request to activate the virtual circuit.

### How-to: Provision a Cloud Interconnect

Enterprise customers using Magic WAN can get started with Cloud Interconnect by contacting their account team.

#### AWS Direct Connect (beta)

If you are a Magic WAN customer, you can connect to [AWS Direct Connect](https://docs.aws.amazon.com/directconnect/) using Cloud Interconnect. Cloud Interconnect supports AWS Dedicated Direct Connect, which provides a full physical port allocation in AWS. AWS Hosted Direct Connect is not yet supported.

For your AWS Dedicated Direct Connect, you can choose between connection speeds of 10 Gbps or 1 Gbps.

To connect to AWS Direct Connect:

1. Contact your account team to start the Cloud Interconnect provisioning process. Your team will let you know of available interconnect locations so you can choose the best one for you, as well as all the details involved in this process.
2. Log in to your AWS portal and order a Direct Connect.
3. AWS will provide you a Letter of Authorization (LOA) and a VLAN ID that you need to send to your account team.
4. Your account team will continue the process of provisioning your Cloud Interconnect with the AWS documents you have provided. Overall, this process should take around four weeks to finish.

#### Google Cloud interconnect (beta)

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account.
2. Select **Interconnects** > **Create new**.
3. Under **Cloud Interconnect**, select **Create new**.
4. Under **Google Integration**, select **Select integration**.
5. Give your interconnect a name and optionally a description. Make sure the MTU value matches the MTU configured on the [GCP VLAN attachment](https://cloud.google.com/network-connectivity/docs/interconnect/how-to/dedicated/creating-vlan-attachments).
6. Select **Continue**.
7. From the **Interface speed** drop-down menu, select an interface speed. GCP will charge you based on the speed of the interconnect that you choose.
8. Enter your [VLAN attachment pairing key](https://cloud.google.com/network-connectivity/docs/interconnect/how-to/partner/creating-vlan-attachments).
9. Select **Continue**.
10. Review the details you provided, and select **Confirm order**.

Your Google Cloud Platform (GCP) interconnect will take a few minutes to be available. A BGP session will be established but no routes will be exchanged.

#### GCP next steps

You can now select **View interconnects** for a list of all interconnects on your account. Select the interconnect name to show the interconnect details. The interconnect has a unique **Interconnect ID**.

After you have configured your Google Cloud Interconnect, you will need to add routes to use the interconnect:

* To create routes in the Magic routing table to direct traffic towards GCP:

  * Add [static routes](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-routes/#configure-static-routes) to your Magic WAN routing table with [legacy bidirectional tunnel health checks](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-tunnel-endpoints/#legacy-bidirectional-health-checks) to detect failures and steer traffic to alternative paths.
  * Note that routes advertised by BGP from GCP Cloud Router will be ignored.

* To create routes in GCP routing table to direct traffic towards Cloudflare, you must use the GCP Cloud Router:

  * Add [custom learned routes to Cloud Router](https://cloud.google.com/network-connectivity/docs/router/how-to/configure-custom-learned-routes).
  * Use the BGP session. Reach out to your account team to request a list of one or more prefixes to advertise, and specify the interconnect ID you want to advertise over.
