---
title: CSP HTTP header format · Cloudflare Page Shield docs
description: "The format of the Content Security Policy (CSP) report-only HTTP
  header added by Page Shield is the following:"
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/page-shield/reference/csp-header/
  md: https://developers.cloudflare.com/page-shield/reference/csp-header/index.md
---

The format of the Content Security Policy (CSP) report-only HTTP header added by Page Shield is the following:

```txt
content-security-policy-report-only: script-src 'none'; connect-src 'none'; report-uri https://csp-reporting.cloudflare.com/cdn-cgi/script_monitor/report?<QUERY_STRING>
```

If you [configured the reporting endpoint](https://developers.cloudflare.com/page-shield/reference/settings/#reporting-endpoint) to use the same hostname, the HTTP header will have the following format:

```txt
content-security-policy-report-only: script-src 'none'; connect-src 'none'; report-uri <YOUR_HOSTNAME>/cdn-cgi/script_monitor/report?<QUERY_STRING>
```

Notes

Cloudflare adds the CSP report-only HTTP header used to monitor webpage resources to a sample of sent responses.

Configuring [log policies](https://developers.cloudflare.com/page-shield/policies/) will add other CSP report-only headers to responses. Cloudflare will not perform any sampling for these report-only headers related to customer-defined policies.

## Related resources

* [Mozilla Developer Network's (MDN) documentation on Content-Security-Policy-Report-Only](https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/Content-Security-Policy-Report-Only)
