---
title: Getting Started · Cloudflare Realtime docs
description: >-
  This page guides you through testing the Cloudflare RealtimeKit sample UI, so
  you can quickly experience joining a live session as a peer.

  Follow the instructions to obtain an auth token and try out the SDK in a
  running sample—no full app setup required.
lastUpdated: 2025-11-10T14:20:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/realtime/realtimekit/getting-started/
  md: https://developers.cloudflare.com/realtime/realtimekit/getting-started/index.md
---

This page guides you through testing the Cloudflare RealtimeKit sample UI, so you can quickly experience joining a live session as a peer. Follow the instructions to obtain an auth token and try out the SDK in a running sample—no full app setup required.

### Understanding the RealtimeKit SDK model

Before we get started with RealtimeKit, let's understand the SDK model.

In RealtimeKit, the concepts of [**meeting**](https://developers.cloudflare.com/realtime/realtimekit/concepts/#meeting) and [**participant**](https://developers.cloudflare.com/realtime/realtimekit/concepts/#participant) serve as blueprints—these are database entries that define the structure and roles for real-time interactions. A meeting blueprint outlines the configuration for a collaborative space (such as a classroom, telehealth appointment, or webinar), while a participant blueprint defines the roles and permissions available within that space.

When it comes to real-time usage, these blueprints are instantiated as sessions and peers:

* A [**session**](https://developers.cloudflare.com/realtime/realtimekit/concepts/#session) is a live instance of a meeting, representing an active, real-time interaction.
* A [**peer**](https://developers.cloudflare.com/realtime/realtimekit/concepts/#peer) is a live instance of a participant—an actual user (such as a teacher, student, doctor, or patient) joining the session.

> **Note:** In some contexts, the terms **session** and **meeting**, as well as **peer** and **participant**, are used interchangeably. This is because most people are more familiar with the terms "meeting" and "participant." However, in RealtimeKit, using "session" and "peer" helps differentiate between live instances (sessions and peers) and their blueprints (meetings and participants), making it easier to track and manage them individually in the RealtimeKit dashboard.

The SDK is always initialized from the perspective of a peer joining a session. Each peer’s capabilities and permissions are determined by the participant blueprint and the assigned preset (role configuration) you defined during setup.

This design means:

* Every SDK instance represents a single peer (runtime participant) in a specific session (runtime meeting).
* The peer’s role (e.g., teacher, student, doctor, patient) is established when generating their authentication token, based on the participant blueprint and preset.
* The SDK enforces permissions and features according to the preset, without distinguishing between participant types at the API level.
* This approach allows you to create sessions where diverse roles (like instructors and students, or doctors and patients) can interact with tailored capabilities, all based on their blueprint definitions.

In summary, think of meetings and participants as templates or blueprints, and sessions and peers as their real-time, live counterparts. Each client (browser, device, or app) initializes the SDK as a peer, using an auth token that encodes their permissions and role for that session.

To put this model into practice, you’ll follow these steps:

1. **Create an API token** with Realtime permissions.
2. **Create a RealtimeKit App** to logically organize and manage your meetings.
3. **Create a Meeting** within the app, which acts as a blueprint for a real-time session.
4. **Add a Participant** and generate an authentication token for the peer who will join the session.
5. **Initialize the SDK** using the participant’s auth token.
6. **Join the session as a peer**—enabling real-time interaction with others in the meeting.

### Create a Cloudflare API token with Realtime permissions

To integrate RealtimeKit in your application, you must have a Cloudflare API token with **Realtime** access permissions. To create an API token:

1. Follow the [Create API token guide](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) to create a new token via the Cloudflare dashboard
2. When configuring permissions, ensure you include **Realtime** access
3. Configure any additional [access policies and restrictions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) as needed for your use case

Alternatively, you can [create tokens programmatically via the API](https://developers.cloudflare.com/fundamentals/api/how-to/create-via-api/) if you prefer automation.

Make sure to select the Realtime product with Admin access.

![Screenshot showing the Realtime permission token section in the Cloudflare dashboard](https://developers.cloudflare.com/_astro/permission-token-section.DWgZ7Ag2_106OIT.webp)

If you run the following command and your setup is correct, you should receive a list of your existing Cloudflare RealtimeKit apps and a 200 status code. If you have no apps, the response will be an empty array with a 200 status code.

```bash
curl --location 'https://api.cloudflare.com/client/v4/accounts/<account_id>/realtime/kit/apps' \
--header 'Authorization: Bearer <api_token>'
```

If you do not receive a 200 status code, check your permissions or verify that your API token is valid.

You can also view and manage your apps directly in the [Cloudflare RealtimeKit dashboard](https://dash.cloudflare.com/?to=/:account/realtime/kit).

### Create a Cloudflare RealtimeKit app

Once you have your API token ready, the next step is to create a RealtimeKit app. You can use our [API reference](https://developers.cloudflare.com/api/resources/realtime_kit/) for details on creating an app, or use the following sample request:

```bash
curl --location 'https://api.cloudflare.com/client/v4/accounts/<account_id>/realtime/kit/apps' \
--header 'Content-Type: application/json' \
--header 'Authorization: Bearer <api_token>' \
--data '{
    "name": "My First Cloudflare RealtimeKit app"
}'
```

For more about apps and their role, see the [RealtimeKit Concepts guide](https://developers.cloudflare.com/realtime/realtimekit/concepts/#app).

### Sandbox vs. production app

It’s best practice to create separate apps for your production and staging environments. This helps you test changes safely without impacting your live environment.

For example, you might name your staging app as `<product_name> - staging` and your production app as `<product_name> - production`. You are free to choose any app name that fits your workflow.

### Create a meeting

After creating your app, create a new meeting using the API:

```bash
curl --location 'https://api.cloudflare.com/client/v4/accounts/<account_id>/realtime/kit/<app_id>/meetings' \
--header 'Content-Type: application/json' \
--header 'Authorization: Bearer <api_token>' \
--data '{
    "title": "My First Cloudflare RealtimeKit meeting"
}'
```

To verify your meeting, list all meetings for your app:

```bash
curl --location 'https://api.cloudflare.com/client/v4/accounts/<account_id>/realtime/kit/<app_id>/meetings' \
--header 'Authorization: Bearer <api_token>'
```

Be sure to keep the ID of your newly created meeting for the next steps. You can check more about the Meeting APIs in the [API reference](https://developers.cloudflare.com/api/resources/realtime_kit/subresources/meetings/).

### Create a preset for a participant

Before adding participants, you need to decide what permissions they should have. Presets define these permissions, and RealtimeKit provides some default presets to get you started. Learn more about presets in the [Concepts guide](https://developers.cloudflare.com/realtime/realtimekit/concepts/#preset).

To see existing presets, run:

```bash
curl --location 'https://api.cloudflare.com/client/v4/accounts/<account_id>/realtime/kit/<app_id>/presets' \
--header 'Authorization: Bearer <api_token>'
```

You can create new presets using the [API reference](https://developers.cloudflare.com/api/resources/realtime_kit/subresources/presets/methods/create/) or via the [RealtimeKit dashboard](https://dash.cloudflare.com/?to=/:account/realtime/kit).

Keep the preset name handy for the next step.

Note

**Presets can be reused across multiple meetings.**

This means you can define a role (such as "teacher" or "viewer") once and assign it to participants in any number of meetings, ensuring consistent permissions and experience. For example, the same `teacher` preset can be used for all classrooms, so you don’t have to redefine permissions every time you create a new meeting. This streamlines setup and helps maintain standardized roles across your organization.

### Add a participant

With your meeting and preset ready, add a participant using the following command. Replace all placeholder values with your actual data:

```bash
curl --location 'https://api.cloudflare.com/client/v4/accounts/<account_id>/realtime/kit/<app_id>/meetings/<meeting_id>/participants' \
--header 'Content-Type: application/json' \
--header 'Authorization: Bearer <api_token>' \
--data '{
  "name": "Mary Sue",
  "preset_name": "<preset_name>",
  "custom_participant_id": "<any_uuid_to_identify_participant>"
}'
```

**Field explanations:**

* `name`: The display name of the peer. This can be any string and will be shown to other peers in the live session of a meeting.
* `preset_name`: The name of the preset you created or selected earlier. This determines the permissions and capabilities assigned to the participant.
* `custom_participant_id`: A unique identifier for the participant within this meeting. If you call the Add Participant API again with the same `custom_participant_id` for the same meeting, RealtimeKit will not create a duplicate participant but will instead return the existing participant's token. This can be any unique string, such as a UUID. **Do not use email addresses or personally identifiable information (PII)** here to proactively avoid sharing sensitive details. This UUID will be available in SDK for you to use later on.

The response will include an auth token, which is required for the participant to join the meeting. See the [API reference](https://developers.cloudflare.com/api/resources/realtime_kit/subresources/meetings/methods/add_participant/) for more details on participant management.

### Try the example UI with your participant auth token

After you receive the auth token, try the default UI example for your platform:

* Web Components

  **Run the default-meeting-ui example ([GitHub repo](https://github.com/cloudflare/realtimekit-web-examples/tree/main/html-examples/examples/default-meeting-ui))**

  1. Clone the example:

     ```bash
     git clone https://github.com/cloudflare/realtimekit-web-examples.git
     cd realtimekit-web-examples/html-examples/examples/default-meeting-ui
     ```

  2. Install vite globally for testing:

     ```bash
     npm i -g vite
     ```

  3. Start the development server:

     ```bash
     vite
     ```

  4. Open the app in your browser. To join the session, **append your auth token to the preview URL**:

     ```plaintext
     http://localhost:5173/?authToken=<participant_auth_token>
     ```

     Replace `<participant_auth_token>` with the token you received from the Add Participant API.

* React

  **Run the default-meeting-ui example ([GitHub repo](https://github.com/cloudflare/realtimekit-web-examples/tree/main/react-examples/examples/default-meeting-ui))**

  1. Clone the example:

     ```bash
     git clone https://github.com/cloudflare/realtimekit-web-examples.git
     cd realtimekit-web-examples/react-examples/examples/default-meeting-ui
     ```

  2. Install dependencies:

     ```bash
     npm install
     ```

  3. Start the development server:

     ```bash
     npm run dev
     ```

  4. Open the app in your browser. To join the session, **append your auth token to the preview URL**:

     ```plaintext
     http://localhost:5173/?authToken=<participant_auth_token>
     ```

     Replace `<participant_auth_token>` with the token you received from the Add Participant API.

Note

If there isn’t an active session for your meeting, initializing the SDK with a valid auth token will automatically create a new session for you.

Feel free to explore additional example applications and use cases on our [GitHub](https://github.com/cloudflare). These resources can help you further experiment and accelerate your integration with RealtimeKit.
