---
title: Protect data center networks · Cloudflare Reference Architecture docs
description: This document focuses on the reference architecture of using
  Cloudflare's Magic WAN, Magic Firewall, and Cloudflare Gateway services.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/reference-architecture/diagrams/network/protect-data-center-networks/
  md: https://developers.cloudflare.com/reference-architecture/diagrams/network/protect-data-center-networks/index.md
---

## Introduction

Network security teams have traditionally used various network firewalls or security appliances at the perimeter to protect their data center networks against both external and internal threats, for example, DDoS attacks, malware, ransomware, phishing, leaking of sensitive information, etc. In addition, the same or additional firewall or security appliances are deployed at the [DMZ](https://en.wikipedia.org/wiki/DMZ_\(computing\)) or core layer of the data center networks to control and secure internal private network traffic routed between multiple data center sites across their wide-area network (WAN).

But these firewalls and security appliances are often expensive, complex to configure and manage, difficult to scale to handle large attacks, and require upgrades and patches to defend against newly discovered threats and vulnerabilities.

[Cloudflare Magic Transit](https://developers.cloudflare.com/magic-transit/), [Magic WAN](https://developers.cloudflare.com/magic-wan/), [Magic Firewall](https://developers.cloudflare.com/magic-firewall/) and [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) services running natively on [Cloudflare's massive global network](https://www.cloudflare.com/network/) provide solutions to all the shortcomings described above and more. These services offer in-line, scalable and performant global protection for your data center networks, all from a single cloud network platform.

* [Magic Transit](https://www.cloudflare.com/network-services/products/magic-transit/) provides instant detection and mitigation against network-layer DDoS attacks on your public, Internet-facing networks.
* [Magic WAN](https://www.cloudflare.com/network-services/products/magic-wan/) provides any-to-any, hybrid/multi-cloud secure connectivity between your private, enterprise networks.
* [Magic Firewall](https://developers.cloudflare.com/magic-firewall/) is a cloud-native network firewall service that can be used to filter traffic that is routed to and from your networks that are protected by Magic Transit. It also supports functionalities such as [Intrusion Detection](https://developers.cloudflare.com/magic-firewall/about/ids/) (IDS) and [packet capture](https://developers.cloudflare.com/magic-firewall/packet-captures/).
* [Gateway](https://www.cloudflare.com/zero-trust/products/gateway/) is a secure web gateway (SWG) service that allows you to inspect and control both Internet-bound traffic that is originated from your networks, as well as private network-to-private network traffic (that is, east-west), by proxying such traffic through Cloudflare's global network while applying DNS, network and HTTP based [policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/).

This document focuses specifically on the reference architectures of using Cloudflare Magic Transit, Magic WAN, Magic Firewall and Cloudflare Gateway services to protect both external and internal communications to your data center networks. For details of how Magic Transit, Magic WAN, Magic Firewall and Cloudflare Gateway works and how it can be architected for various use cases, see the linked resources at the end of the document.

To illustrate the architecture and how it works, the following diagrams visualize an example corporation with a set of data center networks that are either public-facing, connecting to users on the Internet or private, internal facing, used for communication within the enterprise. These networks are deployed at two on-premises locations. The prefixes of the public-facing networks are to be protected by Cloudflare Magic Transit.

| Data center 1 | Data center 2 |
| - | - |
| Public-facing network: `192.0.2.0/24` | Public-facing network: `203.0.113.0/24` |
| Private network: `192.168.1.0/24` | Private network: `172.16.2.0/24` |

The edge router(s) at each data center is connected to Cloudflare network via two Direct [Cloudflare Network Interconnect](https://developers.cloudflare.com/network-interconnect/) (CNI) connections, which are direct, private connections between your network and Cloudflare network. One of the Direct CNI connections is for carrying public-facing network traffic, while the other is for carrying private network traffic. Optionally, you can choose to carry both public and private network traffic over a single CNI connection but many organizations do desire to transport external and internal network traffic over separate connections in their security practice.

* For data center 1, CNI connection 1 is used to transport public-facing network traffic and connection 2 is used to transport private network traffic.
* For data center 2, CNI connection 3 is used to transport public-facing network traffic and connection 4 is used to transport private network traffic.

## Protect inbound traffic to public-facing networks

The reference architecture diagram below illustrates how Cloudflare Magic Transit and Magic Firewall can be used to protect the data centers' public-facing networks from inbound traffic originating from the Internet.

![Figure 1. Protect Public-facing Networks from Inbound Traffic.](https://developers.cloudflare.com/_astro/figure1.ByCLqfND_27Cs8B.svg)

1. Using Border Gateway Protocol ([BGP](https://www.cloudflare.com/learning/security/glossary/what-is-bgp/)) and [IP anycast](https://www.cloudflare.com/learning/cdn/glossary/anycast-network/), Cloudflare advertises the customer's protected IP prefixes to the Internet from all of [Cloudflare's global data centers](https://www.cloudflare.com/network/). At the same time, on-premises network(s) would stop advertising the same exact prefixes from their respective on-premises border routers. This ensures that all traffic passes through Cloudflare for Magic Transit DDoS protection and policy enforcement before being delivered to the customer's data center. Internet traffic destined to these protected IP prefixes will always be routed to the Cloudflare data center that is closest to the source of the traffic. Optionally, you could advertise less-specific IP prefixes from the border routers to the Internet. This way, in the unlikely event of a Magic Transit service failure, traffic can be quickly re-routed directly to network locations from the Internet.
2. Traffic originating from the Internet and destined to the protected IP prefixes is ingested into the global Cloudflare network.
3. All DDoS attack traffic is mitigated in-line, close to the sources, at every Cloudflare data center using advanced and automated [DDoS mitigation](https://developers.cloudflare.com/ddos-protection/) technologies.
4. Traffic that passes DDoS mitigation is subjected to additional network firewall filtering using [Magic Firewall](https://developers.cloudflare.com/magic-firewall/).
5. Clean, filtered traffic is routed to the protected networks through Direct [Cloudflare Network Interconnect](https://developers.cloudflare.com/network-interconnect/) (CNI) connections.
6. There are two ways to route server return traffic back to the clients. One way is to route it natively out of the data center and onto the Internet, bypassing Cloudflare network. This method is called Direct Server Return (DSR). It results in asymmetric routing for the bi-directional traffic, which may cause problems with network security and traffic filtering when there are stateful firewalls or NAT devices in the network path, either through other parts of the data center or between the data center and the Internet. Caution needs to be taken in ensuring such an issue does not exist in your network. The other way is to symmetrically route server return traffic back through the Cloudflare network, over the same connection that carries the client-to-server traffic, using [Magic Transit Egress](https://developers.cloudflare.com/magic-transit/reference/egress/). This method is depicted in the diagram above, where the server return traffic is routed to the Cloudflare network via the same CNIs that transport public-facing network traffic from Cloudflare to the data center, using routing techniques such as policy-based routing (PBR) at your sites.
7. Magic Transit Egress traffic is subject to Magic Firewall filtering before being routed out to the Internet towards the users.

## Protect Internet access from public-facing networks

The reference architecture diagram below illustrates how Cloudflare services - Magic Transit (Egress), Magic Firewall, and Cloudflare Gateway can be used to protect outbound Internet traffic originating from the data centers' public-facing networks (that is, servers with public IP addresses).

![Figure 2. Protect outbound traffic from public-facing networks.](https://developers.cloudflare.com/_astro/figure2.CWqDwBZ8_Z6CAdb.svg)

1. Each site network routes outbound Internet traffic originating from the public-facing networks to Cloudflare, via the same CNIs that inbound traffic traverses. This can be done at your site through routing techniques of your choice, such as policy based routing (PBR).
2. Upon entering the Cloudflare network, outbound Internet traffic is first routed through Magic Firewall where it is subject to any configured network firewall policies.
3. Outbound Internet traffic is subsequently sent to [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/), our secure web gateway service where various [policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) enforce a comprehensive set of security and control measures on the outbound traffic, ensuring the utmost protection for your networks. For example, Gateway DNS and HTTP policies can both be configured to prevent your servers from connecting to questionable Internet sites and from downloading malware or other malicious content.
4. Once traffic clears inspection, Gateway proxies the outbound traffic to their destinations on the Internet. The source IP addresses of the outbound traffic are the Cloudflare owned IP addresses associated with the Gateway service, which if you want you can purchase and set your [own egress IP](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/dedicated-egress-ips/)
5. Return traffic from the Internet, destined to Cloudflare's IP addresses linked to the Gateway service, is routed into Cloudflare's global network.
6. Traffic is inspected against Gateway policies.
7. Return traffic that passes Gateway inspection is routed to Magic Firewall for further packet filtering.
8. Return traffic that passes Magic Firewall filtering is routed from Cloudflare to your network locations via CNIs that transport public-facing network traffic.

## Protect site-to-site, inter-data center, private network traffic

The reference architecture diagrams below illustrate how Cloudflare services — Magic WAN, Magic Firewall and Cloudflare Gateway — can be used to protect site-to-site, inter-data center traffic between your private networks.

**Site to Site Private Network Traffic Connectivity**

First, let us examine the use case where you do not intend to subject site-to-site private network traffic to Cloudflare Gateway proxy firewall service and simply route it using Magic WAN service.

![Figure 3.1. Protect inter-data center non-gateway-proxied traffic between private networks.](https://developers.cloudflare.com/_astro/figure3.1.Bcrim4pP_Z26Llze.svg)

1. Each site routes site-to-site private network traffic, destined to the other data center location, to Cloudflare Magic WAN via the corresponding CNI connections. This can be done at your site through routing techniques of your choice, such as policy based routing (PBR).
2. Upon entering the Cloudflare network, traffic is routed through Magic Firewall.
3. Magic Firewall subjects traffic to any configured network firewall policies.
4. Traffic that clears the Magic Firewall rules and is not intended to be further proxied by Cloudflare Gateway service, is routed back to the destination network via the corresponding CNI.

**Site to Site Private Network Traffic with Application Level Security Controls**

For the use case where you do want to apply application level policy for fine-grain control and security on certain private network traffic, you can route and proxy such traffic through Magic WAN and Cloudflare Gateway service. The following diagram illustrates the architecture and packet flow of such use cases.

![Figure 3.2: Figure 3.2. Protect inter-data center gateway-proxied traffic between private networks.](https://developers.cloudflare.com/_astro/figure3.2.D9WLCVnf_Z1VopTw.svg)

1. Each site routes private network traffic destined to the other data center location to Cloudflare Magic WAN via the corresponding CNI connections. This can be done at your site through routing techniques of your choice, such as policy based routing (PBR).
2. Upon entering the Cloudflare network, traffic is routed through Magic Firewall where it is subject to any configured network firewall policies.
3. After clearing Magic Firewall, traffic is subsequently routed to [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/), our secure web gateway service.
4. Cloudflare Gateway subjects traffic to any configured L3-7 [policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) that enforce a comprehensive set of security and control measures, ensuring the utmost protection for your networks. Once traffic clears inspection, Gateway proxies the traffic to its destination private network. The source IP addresses of the proxied traffic are the Cloudflare owned IP addresses associated with the Gateway service.
5. The proxied traffic, en-route to its destination private network, is routed through Magic Firewall once again for further packet filtering.
6. Traffic that passes Magic Firewall filtering is routed from Cloudflare to your network locations via the corresponding CNIs that transport private network traffic.

## Protect outbound Internet traffic from private networks

The reference architecture diagram below illustrates how Cloudflare services — Magic WAN, Magic Firewall and Cloudflare Gateway — can be used to protect outbound Internet traffic originating from the data centers' private networks. The use cases and the protection provided to the servers on the private networks are very similar to those described in the previous section about protecting Internet access from public-facing networks. The differences are that the servers have private IP addresses and that Magic WAN service is used in this section, as opposed to the previous section where servers are assigned with public IP addresses and Magic Transit server is used.

![Figure 4. Protect outbound traffic from private networks.](https://developers.cloudflare.com/_astro/figure4.Chl4DAXi_1MuKn9.svg)

1. Each site routes outbound Internet traffic originating from its private networks to Cloudflare Magic WAN via the corresponding CNI connections. This can be done at your site through routing techniques of your choice, such as policy based routing (PBR).
2. Upon entering the Cloudflare network, outbound Internet traffic is first routed through Magic Firewall where it is subject to any configured network firewall policies.
3. Traffic that clears Magic Firewall is subsequently sent to [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/), our secure web gateway service where any configured L3-7 [policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) enforce a comprehensive set of security and control measures on the outbound traffic, ensuring the utmost protection for your networks.
4. Once traffic clears inspection, Gateway proxies the outbound traffic to their destinations on the Internet. The source IP addresses of the outbound traffic are the Cloudflare owned IP addresses associated with the Gateway service.
5. Return traffic from the Internet, destined to Cloudflare's IP addresses linked to the Gateway service, is routed into Cloudflare's global network.
6. Traffic is inspected against Gateway policies.
7. Return traffic that passes Gateway inspection is routed to Magic Firewall for further packet filtering.
8. Return traffic that passes Magic Firewall filtering is routed from Cloudflare to your network locations via CNIs that transport private network traffic.

## Related Resources

* [Cloudflare Magic Transit](https://developers.cloudflare.com/magic-transit/)
* [Cloudflare DDoS Protection](https://developers.cloudflare.com/ddos-protection/)
* [Magic Transit Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/magic-transit/)
* [Cloudflare Network Interconnect](https://developers.cloudflare.com/network-interconnect/)
* [Cloudflare Magic Firewall](https://developers.cloudflare.com/magic-firewall/)
* [Cloudflare Magic WAN](https://developers.cloudflare.com/magic-wan/)
* [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/)
* [Integration of Cloudflare Magic services and Cloudflare Gateway](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-gateway/)
