---
title: Tables · Cloudflare Style Guide
description: Using tables to simplify content and data provides a comprehensive
  way to arrange design, structure, outlines, pattern, or order. It is a great
  tool for comparisons, breakdowns, lists, functions, and descriptions.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/formatting/structure/tables/
  md: https://developers.cloudflare.com/style-guide/formatting/structure/tables/index.md
---

Using tables to simplify content and data provides a comprehensive way to arrange design, structure, outlines, pattern, or order. It is a great tool for comparisons, breakdowns, lists, functions, and descriptions.

Here are some tips when creating tables:

* Label column headers.
* Label row headers if appropriate.
* Avoid merged cells. When cells are merged, it impacts how a screen reader navigates the page.
* Avoid too much text.
* Aim for parallelism within the column.
* Keep tables as simple and as small as possible.

## When to use tables

Tables display pieces of information that have some sort of relationship.

Example:

* Dates and descriptions, like a changelog
* A list of products with attributes

## When not to use tables

Do not use tables to format a page.

## Markdown examples

**Add a table**

To add a table, use three or more hyphens (---) to create each column’s header, and use pipes (|) to separate each column. For compatibility, you should also add a pipe on either end of the row.

```plaintext
| Syntax      | Description |
| ----------- | ----------- |
| Header      | Title       |
| Paragraph   | Text        |
```

The rendered output looks like this:

| Syntax | Description |
| - | - |
| Header | Title |
| Paragraph | Text |

Tip: Creating tables with hyphens and pipes can be tedious. To speed up the process, try using the [Markdown Tables Generator](https://www.tablesgenerator.com/markdown_tables).

## Alignment

You can align text in the columns to the left, right, or center by adding a colon (:) to the left, right, or on both side of the hyphens within the header row.

```plaintext
| Syntax      | Description | Test Text     |
| :---        |    :----:   |          ---: |
| Header      | Title       | Here is this  |
| Paragraph   | Text        | And more      |
```

The rendered output looks like this:

| Syntax | Description | Test Text |
| - | - | - |
| Header | Title | Here is this |
| Paragraph | Text | And more |

## Formatting text in tables

You can format the text within tables. For example, you can add links, code, and emphasis.

You can’t add headings, blockquotes, lists, horizontal rules, images, or HTML tags.

## Escaping pipe characters in tables

You can display a pipe (|) character in a table by using its HTML character code ("|").

## HTML examples

For complex tables, consider using HTML. The following example is created with HTML:

| Field | Description |
| - | - |
| `http.cookie` `String` | Represents the entire cookie as a string.Example value: `session=8521F670545D7865F79C3D7BEDC29CCE;-background=light` |
| `http.host` `String` | Represents the hostname used in the full request URI.Example value: `www.example.org` |
